#include "interface.h"

// Initialise la SDL
void initialiser_affichage(SDL_Surface** fenetre,long largeur,long hauteur)
{
    char str[255];

    // On initialise la SDL
    if ( SDL_Init( SDL_INIT_VIDEO ) < 0 ) // Mode Video seulement pour le moment
    {
        printf( "Impossible d'initialiser la SDL: %s\n", SDL_GetError() );
        exit(EXIT_FAILURE);
    }

    // On initialise SDL_ttf
    if(TTF_Init() == -1)
    {
        printf("Erreur d'initialisation de TTF_Init : %s\n", TTF_GetError());
        exit(EXIT_FAILURE);
    }

    putenv("SDL_VIDEO_WINDOW_POS=center"); //pour centrer la fentre
    sprintf(str,"%s%s",RESSOURCES_DIR,"icon.png");
    SDL_WM_SetIcon(IMG_Load(str),NULL);

    // On cre la fenetre
    *fenetre = SDL_SetVideoMode(largeur,hauteur, BITSPERPIXEL,SDL_HWSURFACE);
    if (!*fenetre )
    {
        printf("Impossible d'afficher en %ldx%ld: %s\n",largeur,hauteur, SDL_GetError());
        exit(EXIT_FAILURE);
    }

    SDL_WM_SetCaption(TITRE, NULL); //On donne un titre  la fentre
    SDL_EnableUNICODE(1); // On active la saisie Unicode
    SDL_EnableKeyRepeat(250, 100); // On active la rptition des touches dlai 250ms, rptition 100ms
}

// Initialise l'interface et les elements du GUI
void initialiser_interface(t_interface* interface,t_map *map) //Petit commentaire gnral : strlen("abc") renvoie 3... donc il faut 3 '+ 1' octets pour stocker cette chane !!
{
    long n; // compteur
    SDL_Rect coord;
    char str[255];
    str[0]=0;

    interface->accent=0;// Pas d'accent retenu en memoire
    sprintf(str,"%s%s",RESSOURCES_DIR,POLICE_TEXTE); // On rcupre le chemin de l'image
    interface->font = TTF_OpenFont(str, POLICE_TAILLE_NORMALE); // On charge la Police de caractre

    interface->gui_taille=28; // Nombre d'elements dans l'interface
    interface->gui=(t_gui_element**)malloc(interface->gui_taille*sizeof(t_gui_element*)); // On alloue la mmoire de ces lements
    interface->gui_actif = NULL;

    for (n=0;n<interface->gui_taille;n++)
    {
        interface->gui[n]=(t_gui_element*)malloc(interface->gui_taille*sizeof(t_gui_element)); // On alloue les lements
    }

/*
    L'ECRAN qui contient la MAP
*/

/// ELEMENT 0 :  L'cran
    interface->gui[0]->type=IMAGE; // Element de type Image
    interface->gui[0]->image= SDL_CreateRGBSurface(SDL_HWSURFACE,interface->fenetre->w-200+8,interface->fenetre->h,32, 0,0,0,0); // On cre la surface d'affichage de la map
    interface->gui[0]->valeur=NULL;// Pas de Texte
    interface->gui[0]->position.x=0; // On Positionne la barre a cot de l'cran
    interface->gui[0]->position.y=0;// En haut
    interface->gui[0]->crop.x=0; // Position de dpart de l'cran selon X dans la map (en pixels)
    interface->gui[0]->crop.y=0;  // Position de dpart de l'cran selon Y dans la map (en pixels)
    interface->gui[0]->crop.w=interface->fenetre->w-200;  // Largeur de l'cran (en pixels)
    interface->gui[0]->crop.h=interface->fenetre->h;  // Hauteur de l'cran (en pixels)
    interface->gui[0]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[0]->visible=1; // Visible
    interface->gui[0]->groupe=FENETRE; // Appartient  la Fenetre
    interface->gui[0]->flag=ECRAN; // Pas d'action
    interface->gui[0]->free=FREE_IMAGE; // L'image sera libr  la fin

/*
    DESIGN DE LA BARRE LATERALE
*/

n=1; /// ELEMENT 1 :  Arrire-Plan de la Barre Latrale
    interface->gui[n]->type=IMAGE; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"barre.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image de la barre
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w; // On Positionne la barre a cot de l'cran
    interface->gui[n]->position.y=0;// En haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libr  la fin

n++; /// ELEMENT 2 : Minimap
    interface->gui[n]->type=MAP; // Element de type Map
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA,160,160,BITSPERPIXEL, 0,0,0,0);// On cre la surface de la Minimap
    SDL_SetColorKey(interface->gui[n]->image, SDL_SRCCOLORKEY, SDL_MapRGB(interface->fenetre->format, 0, 0, 0)); // Le noir sera transparent
    //SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 200);
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // On place la minimap  20 pixel du bord gauche de la barre latrale,
    interface->gui[n]->position.y=420; // Et  420 pixel du bord haut, dans le trou qui lui est reserv
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=interface->gui[n]->image->w; // On ne rogne pas l'image
    interface->gui[n]->crop.h=interface->gui[n]->image->h; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=MINIMAP; // Action d'une minimap: doit permettre de se deplacer dans le monde
    interface->gui[n]->free=FREE_RIEN; // L'image sera liber via le pointeur interface->minimap, donc rien  liberer ici

n++; /// ELEMENT 3 : Curseur Minimap

    coord=obtenir_curseur_minimap(interface,map);

    interface->gui[n]->type=IMAGE; // Element de type Map
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,coord.w,coord.h,BITSPERPIXEL, 0,0,0,0);// On cre la surface de la Minimap
    SDL_SetColorKey(interface->gui[n]->image, SDL_SRCCOLORKEY, SDL_MapRGB(interface->fenetre->format, 0, 0, 0)); // Le noir sera transparent
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc

    coord.x=1;
    coord.y=1;
    coord.w= interface->gui[n]->image->w - 2;
    coord.h= interface->gui[n]->image->h - 2;

    SDL_FillRect(interface->gui[n]->image, &coord, SDL_MapRGB(interface->fenetre->format, 0, 0, 0)); // On remplit le champ en blanc
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // On place la minimap  20 pixel du bord gauche de la barre latrale,
    interface->gui[n]->position.y=420; // Et  420 pixel du bord haut, dans le trou qui lui est reserv
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=0; // On ne rogne pas l'image
    interface->gui[n]->crop.h=0; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=MINIMAP_CURSEUR; // Action d'une minimap: doit permettre de se deplacer dans le monde
    interface->gui[n]->free=FREE_IMAGE; // On libre l'image du curseur

n++; /// ELEMENT 4 : Texte "Editeur de Maps"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Editeur de Maps") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Editeur de Maps"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[0]->crop.w+50; // On le positionne  50px du bord gauche de la barre,
    interface->gui[n]->position.y=52; // et  72 px du bord haut
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera liber


n++;  /// ELEMENT 5 : Trou / Cadre pour la Tile Actuelle
    interface->gui[n]->type=IMAGE; // Element de type Image
    sprintf(str,"%s%s",RESSOURCES_DIR,"cadre.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+52; // Positionnement  5 px du bord gauche
    interface->gui[n]->position.y=180; // et 200px du bord haut
    interface->gui[n]->crop.x=0; // On prend toute l'image
    interface->gui[n]->crop.y=0; // On prend toute l'image
    interface->gui[n]->crop.w=interface->gui[n]->image->w; // On ne rogne pas l'image
    interface->gui[n]->crop.h=interface->gui[n]->image->h; // On ne rogne pas l'image
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
     interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_IMAGE; // L'image sera libre

/*
    CHAMPS DE CONFIGURATION DE LA MAP
*/

n++; /// ELEMENT 6 : Texte / Label "Nom de la map"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("> Nom de la map") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"> Nom de la map"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[0]->crop.w+8; // Position X du texte
    interface->gui[n]->position.y=76;// Position Y du texte
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera libr


n++; /// ELEMENT 7 :  Saisie du Nom de la Map
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,160,32,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=map->fichier; // Sa valeur pointe directement sur le nom de la map
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // Position en X du champ
    interface->gui[n]->position.y=98; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=160; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE; // On ne libre pas le texte, parce qu'il appartient  la map !!!


n++; /// ELEMENT 8:  Texte / Label "Image du Tileset"
    // On affiche un texte
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("> Image du Tileset") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"> Image du Tileset"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[0]->crop.w+8; // Position X du texte
    interface->gui[n]->position.y=120; // Position Y du texte
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera libr

n++; /// ELEMENT 9:   Saisie du Tileset
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,160,32,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=map->tileset.fichier; // Sa valeur pointe directement sur le nom du tileset
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // Position en X du champ
    interface->gui[n]->position.y=142; // Position en Y du champ
    interface->gui[n]->crop.x=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.y=0; // On part du coin Gauche / Haut
    interface->gui[n]->crop.w=160; // Largeur de 160
    interface->gui[n]->crop.h=24;  // Hauteur de 24
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action lors de sa validation
    interface->gui[n]->free=FREE_IMAGE; // On ne libre pas le texte, parce qu'il appartient  la map !!!

/*
    CONFIGURATION DE LA TILE COURANTE / SELECTIONNEE
*/

n++; /// ELEMENT 10 : Texte "Tile Actuelle"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Tile Actuelle :") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Tile Actuelle :"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[0]->crop.w+16; // Position en X du texte
    interface->gui[n]->position.y=168; // Position en Y du texte
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->etat=INACTIF; // On initialise son tat  INACTIF
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // Le texte sera libr

n++;  /// ELEMENT 11 : Image / Aperu de la Tile courante
    // On dfinit l'image du tile courant
    interface->gui[n]->type=IMAGE; // Element de type Image
    interface->gui[n]->image=map->tileset.image; // Pas d'allocation, on pointe diretement sur le pointeur de la surface du Tileset
    interface->gui[n]->valeur=NULL;// Pas de Texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+84;  // Position en X de l'image (au centre du cadre)
    interface->gui[n]->position.y=212;  // Position en Y de l'image (au centre du cadre)
    interface->gui[n]->crop.x=0; // Tile n0
    interface->gui[n]->crop.y=0; // Tile n0
    interface->gui[n]->crop.w=TILE_TAILLE; // Largeur d'une Tile
    interface->gui[n]->crop.h=TILE_TAILLE; // Hauteur d'une Tile
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=TILEACTUELLE; // Action: l'image doit correspondre  la tile actuelle
    interface->gui[n]->free=FREE_RIEN; // On ne libre rien ici

n++; /// ELEMENT 12 : Bouton Tile Prcdente
    interface->gui[n]->type=BOUTON; // Element de type Bouton
    sprintf(str,"%s%s",RESSOURCES_DIR,"boutonprecedent.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=NULL; // Pas de texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+18; // Position en X de l'image ( gauche de la tile actuelle)
    interface->gui[n]->position.y=212; // Position en Y de l'image (aligne avec la tile actuelle)
    interface->gui[n]->crop.x=0; // On part du bord gauche (etat inactif)
    interface->gui[n]->crop.y=0; // On part du bord tout en haut (etat inactif)
    interface->gui[n]->crop.w=32; // Hauteur du bouton
    interface->gui[n]->crop.h=32; // Largeur du bouton
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=TILE_PRECEDENT; // Action: Tile prcdente
    interface->gui[n]->free=FREE_IMAGE; // On libre l'image du bouton

n++; /// ELEMENT 13 :  Bouton Tile Suivante
    interface->gui[n]->type=BOUTON; // Element de type Bouton
    sprintf(str,"%s%s",RESSOURCES_DIR,"boutonsuivant.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->valeur=NULL; // Pas de texte
    interface->gui[n]->position.x=interface->gui[0]->crop.w+150; // Position en X de l'image ( droite de la tile actuelle)
    interface->gui[n]->position.y=212; // Position en Y de l'image (aligne avec la tile actuelle)
    interface->gui[n]->crop.x=0; // On part du bord gauche (etat inactif)
    interface->gui[n]->crop.y=0; // On part du bord tout en haut (etat inactif)
    interface->gui[n]->crop.w=32; // Hauteur du bouton
    interface->gui[n]->crop.h=32; // Largeur du bouton
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=TILE_SUIVANT; // Action: Tile suivante
    interface->gui[n]->free=FREE_IMAGE; // On libre l'image du bouton

n++; /// ELEMENT 14 : 1re ligne du Texte "Cout du \n Mouvement"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Cot du") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Cot du"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[0]->crop.w+24; // Position en X du texte
    interface->gui[n]->position.y=264; // Position en Y du texte
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // On libre le texte allou


n++; /// ELEMENT 15 : 2me ligne du Texte "Cout du \n Mouvement"
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Mouvement:") + 1); // On alloue la mmoire pour le texte
    strcpy(interface->gui[n]->valeur,"Mouvement:"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[0]->crop.w+12; // Position en X du texte
    interface->gui[n]->position.y=284; // Position en Y du texte
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // On libre le texte allou


n++;/// ELEMENT 16 : Saisie du Cout du Mouvement de la Tile Actuelle
    interface->gui[n]->type=SAISIE; // Element de type Saisie
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE,160,32,BITSPERPIXEL, 0,0,0,0);// On cre la surface du champ
    SDL_FillRect(interface->gui[n]->image, 0, SDL_MapRGB(interface->fenetre->format, 255, 255, 255)); // On remplit le champ en blanc
    interface->gui[n]->valeur=(char*)malloc(SAISIE_MAX+1);// On stocke la saisie sur 32 octets
    sprintf(interface->gui[n]->valeur,"%ld",map->tile[interface->tile].cout_pts); // On initialise la valeur courante du cout
    interface->gui[n]->position.x=interface->gui[0]->crop.w+96; // Position en X du champ
    interface->gui[n]->position.y=272;// Position en Y du champ
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=48; // Largeur de 48px
    interface->gui[n]->crop.h=24; // Hauteur de 24px
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=TILE_COUT;  // Action: Modifie le cout de la tile actuelle (formatage necessaire)
    interface->gui[n]->free=FREE_VALEUR|FREE_IMAGE; // On libre la valeur stocke cette fois, ainsi que l'image


n++; /// ELEMENT 17 : Texte "Points" apres le champ
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(strlen("Points") + 1); // On alloue la mmoire pour le texte
    sprintf(interface->gui[n]->valeur,"Points"); // On inscrit le texte dans l'element
    interface->gui[n]->position.x=interface->gui[0]->crop.w+144; // Position en X du texte
    interface->gui[n]->position.y=272; // Position en Y du texte
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=AUCUN; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // On libre le texte allou

n++; /// ELEMENT 18 : Bouton Gnrer une map
    interface->gui[n]->type=BOUTON; // Element de type Bouton
    interface->gui[n]->valeur=(char*)malloc(strlen("Gnrer une map") + 1); // On alloue la mmoire pour le texte du bouton
    sprintf(interface->gui[n]->valeur,"Gnrer une map"); // On inscrit le texte dans l'element
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // Position en X du bouton
    interface->gui[n]->position.y=348; // Position en Y du bouton
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=160; // largeur 160px
    interface->gui[n]->crop.h=32;// Hauteur 32 px
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=GENERER; // Action: Sauvegarder la map
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image ET le texte.

n++; /// ELEMENT 18 : Bouton Sauvegarder la map
    interface->gui[n]->type=BOUTON; // Element de type Bouton
    interface->gui[n]->valeur=(char*)malloc(strlen("Sauvegarder") + 1); // On alloue la mmoire pour le texte du bouton
    sprintf(interface->gui[n]->valeur,"Sauvegarder"); // On inscrit le texte dans l'element
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // Position en X du bouton
    interface->gui[n]->position.y=380; // Position en Y du bouton
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=160; // largeur 160px
    interface->gui[n]->crop.h=32;// Hauteur 32 px
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=SAUVEGARDER; // Action: Sauvegarder la map
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image ET le texte.

n++; /// ELEMENT_SWITCH_TYPE 19 - Bouton Switchable du Menu Droulant
ELEMENT_SWITCH_TYPE=n; // Globale pour le dveloppement

    interface->gui[n]->type=SWITCH; // Element de type Switch
    interface->gui[n]->valeur=(char*)malloc(32); // On alloue la mmoire pour le texte du bouton (max 31 caractres)
    strcpy(interface->gui[n]->valeur,"Switch"); // On inscrit un texte dans l'element
    sprintf(str,"%s%s",RESSOURCES_DIR,"switch1.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->position.x=interface->gui[0]->crop.w+20; // Position en X du bouton
    interface->gui[n]->position.y=316; // Position en Y du bouton
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=160; // largeur 160px
    interface->gui[n]->crop.h=32;// Hauteur 32 px
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=BARRE; // Appartient  la Barre latrale
    interface->gui[n]->flag=SWITCH_TYPE;  // Action: Afficher/Masquer le menu deroulant du type de terrain
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image ET le texte.

n++; /// ELEMENT 20 : element 1 du menu droulant SWITCH_TYPE
    interface->gui[n]->type=BOUTON; // Element de type Bouton
    interface->gui[n]->valeur=(char*)malloc(strlen("Sol") + 1); // On alloue la mmoire pour le texte du bouton
    strcpy(interface->gui[n]->valeur,"Sol"); // On inscrit le texte dans l'element
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton2.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du bouton (Hrite)
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+interface->gui[n-1]->crop.h;// Position en Y du bouton (Hrite)
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=160; // largeur 160px
    interface->gui[n]->crop.h=32;// Hauteur 32 px
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_TYPE; // Appartient au menu droulant du Type
    interface->gui[n]->flag=TILE_TYPE_SOL; // Action: Parametrer le type du terrain  SOL
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image ET le texte.

n++; /// ELEMENT 21 : element 2 du menu droulant SWITCH_TYPE
    interface->gui[n]->type=BOUTON; // Element de type Bouton
    interface->gui[n]->valeur=(char*)malloc(strlen("Obstacle") + 1); // On alloue la mmoire pour le texte du bouton
    strcpy(interface->gui[n]->valeur,"Obstacle"); // On inscrit le texte dans l'element
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton2.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du bouton (Hrite)
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+interface->gui[n-1]->crop.h;// Position en Y du bouton (Hrite)
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=160; // largeur 160px
    interface->gui[n]->crop.h=32;// Hauteur 32 px
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_TYPE; // Appartient au menu droulant du Type
    interface->gui[n]->flag=TILE_TYPE_OBSTACLE;// Action: Parametrer le type du terrain  OBSTACLE
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre le texte et l'image

n++; /// ELEMENT 22 : element 3 du menu droulant SWITCH_TYPE
    interface->gui[n]->type=BOUTON; // Element de type Bouton
    interface->gui[n]->valeur=(char*)malloc(strlen("Camp") + 1); // On alloue la mmoire pour le texte du bouton
    strcpy(interface->gui[n]->valeur,"Camp"); // On inscrit le texte dans l'element
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton2.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du bouton (Hrite)
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+interface->gui[n-1]->crop.h;// Position en Y du bouton (Hrite)
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=160; // largeur 160px
    interface->gui[n]->crop.h=32;// Hauteur 32 px
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_TYPE; // Appartient au menu droulant du Type
    interface->gui[n]->flag=TILE_TYPE_CAMP;// Action: Parametrer le type du terrain  MORTEL
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 23 : element 4 du menu droulant SWITCH_TYPE
    interface->gui[n]->type=BOUTON; // Element de type Bouton
    interface->gui[n]->valeur=(char*)malloc(strlen("Mortel") + 1); // On alloue la mmoire pour le texte du bouton
    strcpy(interface->gui[n]->valeur,"Mortel"); // On inscrit le texte dans l'element
    sprintf(str,"%s%s",RESSOURCES_DIR,"bouton2.png"); // On rcupre le chemin de l'image
    interface->gui[n]->image=IMG_Load(str);// On charge l'image
    if ( !interface->gui[n]->image ){printf ( "IMG_Load: %s\n", IMG_GetError () ); exit(EXIT_FAILURE);} // ERREUR lors du chargement
    interface->gui[n]->position.x=interface->gui[n-1]->position.x; // Position en X du bouton (Hrite)
    interface->gui[n]->position.y=interface->gui[n-1]->position.y+interface->gui[n-1]->crop.h;// Position en Y du bouton (Hrite)
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=160; // largeur 160px
    interface->gui[n]->crop.h=32;// Hauteur 32 px
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=MENU_TYPE; // Appartient au menu droulant du Type
    interface->gui[n]->flag=TILE_TYPE_MORTEL;// Action: Parametrer le type du terrain  MORTEL
    interface->gui[n]->free=FREE_IMAGE|FREE_VALEUR; // On libre l'image et le texte

n++; /// ELEMENT 24 : Fond de la Fenetre de Chat
    interface->gui[n]->type=IMAGE; // Element de type Bouton
    interface->gui[n]->valeur=NULL; // On alloue la mmoire pour le texte du bouton
    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA , 536, 192, BITSPERPIXEL, RMASK, GMASK, BMASK, AMASK);
    SDL_FillRect(interface->gui[n]->image, NULL, SDL_MapRGBA(interface->gui[n]->image->format, 0, 0, 0,128));
    //SDL_SetAlpha( front, SDL_SRCALPHA | SDL_RLEACCEL, alpha );
    //SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 128);
    interface->gui[n]->position.x=32; // Position en X du bouton (Hrite)
    interface->gui[n]->position.y=376;// Position en Y du bouton (Hrite)
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=536; // largeur 160px
    interface->gui[n]->crop.h=192;// Hauteur 32 px
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=POPUP_CHAT; // Appartient au menu droulant du Type
    interface->gui[n]->flag=AUCUN;// Action: Parametrer le type du terrain  MORTEL
    interface->gui[n]->free=FREE_IMAGE; // On libre l'image

n++; /// ELEMENT 25 : Fenetre du Chat
    interface->gui[n]->type=IMAGE; // Element de type Bouton
    interface->gui[n]->valeur=(char *)malloc(32); // On alloue la mmoire pour le texte du bouton
    sprintf(interface->gui[n]->valeur,"%ld",(long)-5000);

    interface->gui[n]->image=SDL_CreateRGBSurface(SDL_HWSURFACE|SDL_SRCALPHA , 528, 192, BITSPERPIXEL, RMASK, GMASK, BMASK, AMASK);
    SDL_FillRect(interface->gui[n]->image, NULL, SDL_MapRGBA(interface->gui[n]->image->format, 0,0,0,0));
    //SDL_SetAlpha( front, SDL_SRCALPHA | SDL_RLEACCEL, alpha );
    //SDL_SetAlpha(interface->gui[n]->image, SDL_SRCALPHA, 128);
    interface->gui[n]->position.x=36; // Position en X du bouton (Hrite)
    interface->gui[n]->position.y=376;// Position en Y du bouton (Hrite)
    interface->gui[n]->crop.x=0; // Bord Gauche
    interface->gui[n]->crop.y=0; // Haut
    interface->gui[n]->crop.w=528; // largeur 160px
    interface->gui[n]->crop.h=192;// Hauteur 32 px
    interface->gui[n]->visible=0; // Visible
    interface->gui[n]->groupe=POPUP_CHAT; // Appartient au menu droulant du Type
    interface->gui[n]->flag=MESSAGES;// Action: Contient les messages du programme
    interface->gui[n]->free=FREE_IMAGE; // On libre l'image

n++; /// ELEMENT 26 : FPS
    interface->gui[n]->type=TEXTE; // Element de type Texte
    interface->gui[n]->image=NULL; // Pas d'image
    interface->gui[n]->valeur=(char*)malloc(4); // On alloue la mmoire pour le texte
    interface->gui[n]->valeur[0]=0;
    interface->gui[n]->position.x=2; // Position en X du texte
    interface->gui[n]->position.y=2; // Position en Y du texte
    interface->gui[n]->crop.x=0; // Pas de crop
    interface->gui[n]->crop.y=0; // Pas de crop
    interface->gui[n]->crop.w=0; // Pas de crop
    interface->gui[n]->crop.h=0; // Pas de crop
    interface->gui[n]->visible=1; // Visible
    interface->gui[n]->groupe=FENETRE; // Appartient au menu droulant du Type
    interface->gui[n]->flag=FPS; // Pas d'action
    interface->gui[n]->free=FREE_VALEUR; // On libre le texte allou
}

// Supprime les donnes de l'interface
void liberer_interface(t_interface* interface) //dite le 25/02/2010  14:11 par Loc
{
    long n; // Compteur

    TTF_CloseFont(interface->font);// On supprime la police de caractre

    for (n=0;n<interface->gui_taille;n++) // Pour chaque element du GUI
    {
        if (interface->gui[n]->free & FREE_IMAGE) // Si on doit supprimer l'image
        {
            SDL_FreeSurface(interface->gui[n]->image); // On supprime l'image
        }

        if (interface->gui[n]->free & FREE_VALEUR)// Si on doit supprimer le texte
        {
            free(interface->gui[n]->valeur);  // On libre le texte
        }

        free(interface->gui[n]); // On libre ensuite l'element
    }

    free(interface->gui); // On supprime enfin les pointeurs vers ces elements

    // la variable interface sera libr  la fin du main automatiquement
}

void liberer_affichage(SDL_Surface* fenetre)
{
    SDL_FreeSurface(fenetre);// On supprime la surface de la fenetre

    TTF_Quit(); // On quitte SDL_ttf
    SDL_Quit(); // On quitte la SDL
}
// Affiche l'interface
void afficher_interface(t_interface* interface,t_map* map)
{
    long n; // Compteur
    SDL_Rect position, crop; // Structures utilises pour le positionnement et le rognage
    SDL_Color couleur; //Contient la couleur du texte  afficher
    SDL_Surface * tmpsurface = NULL; // Surface temporaire
    char str[256]; // Chaine de caractre pour les champ de saisie

    for (n=0;n<interface->gui_taille;n++)
    {
        str[0]=0; // On efface la chaine de caractre
        // On paramtre la couleur du texte  NOIR
        couleur.r=0;
        couleur.g=0;
        couleur.b=0;

        actualiser_gui(n, interface,map);// On actualise l'element courant en fonction de son flag, ainsi que les donnes qu'il concerne

        if (interface->gui[n]->visible) // Si l'element est visible, on l'affiche
        {
            if (interface->gui[n]->type == TEXTE) // Si l'element est de type Texte
            {
                tmpsurface = TTF_RenderText_Blended(interface->font, interface->gui[n]->valeur, couleur); // On place le texte dans la surface temporaire
                SDL_BlitSurface(tmpsurface, 0, interface->fenetre, &interface->gui[n]->position); // On blitte le texte
                SDL_FreeSurface(tmpsurface); // On dtruit la surface temporaire pour une utilisation ultrieure
                /*
                Remarque: On pourrait utiliser le champ image pour la surface au lieu de tmpsurface, mais on pourrait imaginer ke le texte
                aurait un arrire plan color
                */
            }
            else if (interface->gui[n]->type == SAISIE)  // Si l'element est de type Saisie
            {

                sprintf(str,"%s   ",interface->gui[n]->valeur); // On place dans la chaine de caractre temporaire la valeur du champ

                if (interface->gui[n]->etat == ACTIF) // Si l'element est actif (selectionn)
                {
                    if((SDL_GetTicks()/500)%2) // Toutes les demi-secondes
                    {
                            sprintf(str,"%s|",interface->gui[n]->valeur); // On remplace la chaine de caractre pour y rajouter un curseur
                    }
                }

                tmpsurface = TTF_RenderText_Blended(interface->font, str , couleur);// On place le texte dans la surface temporaire


                position.x = interface->gui[n]->position.x + 2; // On laisse un marge de 2px  gauche
                position.y = interface->gui[n]->position.y + ((interface->gui[n]->crop.h - tmpsurface->h)/2); // On centre verticalement le texte dans le champ
                crop=interface->gui[n]->crop; // on rogne le texte  la taille du champ pour eviter qu'il dpasse

                if ((tmpsurface->w+2) > interface->gui[n]->crop.w) // Si le texte est plus large que le champ
                {
                    crop.x=tmpsurface->w-interface->gui[n]->crop.w+2; // On l'aligne sur la droite et non sur la gauche avec une marge de 2 px
                }


                SDL_BlitSurface(interface->gui[n]->image, &interface->gui[n]->crop, interface->fenetre, &interface->gui[n]->position); // On affiche le fond du champ
                SDL_BlitSurface(tmpsurface, &crop , interface->fenetre, &position);// Puis le texte (rogn) par dessus
                SDL_FreeSurface(tmpsurface); // On n'noublie pas de librer la mmoire de la surface temporaire
            }
            else if (interface->gui[n]->type == BOUTON || interface->gui[n]->type == SWITCH) // Si l'element est un bouton (switchable ou non)
            {
                if (interface->gui[n]->valeur) // si le bouton contient un texte
                {
                    tmpsurface = TTF_RenderText_Blended(interface->font, interface->gui[n]->valeur , couleur); // On place le texte dans la surface temporaire

                    if (interface->gui[n]->type == SWITCH) // Si l'element est un switch
                    {
                        // Alignement sur la gauche
                        position.x = interface->gui[n]->position.x + 16; // On garde une marge  gauche de 16px
                        position.y = interface->gui[n]->position.y + ((interface->gui[n]->crop.h - tmpsurface->h)/2); // On centre verticalement le texte dans le champ
                    }
                    else // Sinon
                    {
                        // Alignement centr
                        position.x = interface->gui[n]->position.x + ((interface->gui[n]->crop.w - tmpsurface->w)/2);// On centre horizontalement le texte dans le champ
                        position.y = interface->gui[n]->position.y + ((interface->gui[n]->crop.h - tmpsurface->h)/2);// On centre verticalement le texte dans le champ
                    }
                }

                if (interface->gui[n]->etat == ACTIF) // Si le bouton est actif (enfonc)
                {
                    interface->gui[n]->crop.y=2*interface->gui[n]->crop.h; // On prend la 3eme position dans l'image (Enfonce)
                    // On dplace le texte en diagonale (effet d'enfoncement)
                    position.x+=2; // 2 pixels vers la droite
                    position.y+=2; // 2 pixels vers le bas
                }
                else if (interface->gui[n]->etat == SURVOL) // Sinon si il est juste survol
                {
                    interface->gui[n]->crop.y=interface->gui[n]->crop.h; // On prend la 2eme position dans l'image (Highlighted - Eclaire)
                }
                else // Sinon
                {
                    interface->gui[n]->crop.y=0; // On prend la 1ere position dans l'image (Normale)
                }

                SDL_BlitSurface(interface->gui[n]->image, &interface->gui[n]->crop, interface->fenetre, &interface->gui[n]->position); // On affiche le bouton

                if (interface->gui[n]->valeur) // Toujours si ya un texte
                {
                    SDL_BlitSurface(tmpsurface, 0, interface->fenetre, &position); // On affiche le texte par dessus
                    SDL_FreeSurface(tmpsurface); // On n'noublie pas de librer la mmoire de la surface temporaire
                }
            }
            else if (interface->gui[n]->type == IMAGE) // SI l'element est juste une image
            {
                if (interface->gui[n]->crop.h && interface->gui[n]->crop.w && interface->gui[n]->flag != ECRAN) // Si l'on doit la rogner
                {
                    SDL_BlitSurface(interface->gui[n]->image, &interface->gui[n]->crop, interface->fenetre, &interface->gui[n]->position); // On l'affiche rogne
                }
                else // Sinon
                {
                    SDL_BlitSurface(interface->gui[n]->image, 0, interface->fenetre, &interface->gui[n]->position); // On l'affiche entire
                }
            }
            else if (interface->gui[n]->type == MAP) // Si l'element est de type map
            {
                SDL_BlitSurface(interface->gui[n]->image, 0, interface->fenetre, &interface->gui[n]->position); // On affiche la map comme une image...
            }
        }
    }
}

// Actualise les elements et les donnes avant affichage
void actualiser_gui(long element,t_interface* interface,t_map* map)
{
    SDL_Rect coord;
    long chat_dernier_temps;
    /*
    Remarque: Le switch est ger diffrement que le reste des elements dans la boucle d'evenements, car c'est un bouton ON/OFF,
    il peut tre actif meme si un autre element est selectionn, un clic inverse donc l'activation de ce type d'element
    */
    if (interface->gui[element]->type!=SWITCH)// Si l'element n'est donc pas un switch
    {
        if (interface->gui[element] == interface->gui_actif) // Si l'element est selectionn
        {
            interface->gui[element]->etat=ACTIF; // Alors il est actif
        }
        else if (interface->pointeur.x>=interface->gui[element]->position.x
        && interface->pointeur.x < interface->gui[element]->position.x+interface->gui[element]->crop.w
        && interface->pointeur.y>=interface->gui[element]->position.y
        && interface->pointeur.y < interface->gui[element]->position.y+interface->gui[element]->crop.h
        ) // Si le pointeur est situ entre son coin haut gauche et son coin bas droit
        {
            interface->gui[element]->etat=SURVOL; // Alors il est survol
        }
        else // Sinon
        {
            interface->gui[element]->etat=INACTIF; // Il est inactif
        }
    }
    else // Sinon, si l'element est un switch
    {
        if (interface->gui[element]->etat!=ACTIF) // ET qu'il n'est pas actif, cd, sur la position OFF
        {
            if (interface->pointeur.x>=interface->gui[element]->position.x
            && interface->pointeur.x < interface->gui[element]->position.x+interface->gui[element]->crop.w
            && interface->pointeur.y>=interface->gui[element]->position.y
            && interface->pointeur.y < interface->gui[element]->position.y+interface->gui[element]->crop.h
            ) // Si le pointeur est situ entre son coin haut gauche et son coin bas droit
            {
                interface->gui[element]->etat=SURVOL; // ALors il est survol
            }
            else
            {
                interface->gui[element]->etat=INACTIF; // Sinon, il est juste en position OFF
            }
        }
    }

    /* Remarque:
    Le flag determine comment reagit un element, les donnes qu'il doit actualiser, ce qu'il stocke, et quel aspect
    il doit avoir en fonction des donnes qui lui sont exterieurs
    */
    switch(interface->gui[element]->flag) // On actualise diffrement un element en fonction de son flag
    {
        case ECRAN:
            afficher_map(map,interface); // On blitte la map sur l'ecran
            break;
        case SWITCH_TYPE: // Si l'element est le switch pour le tyep de terrain
            if (interface->gui[element]->etat==ACTIF) // Si le switch est activ - Position ON
            {
                // Alors on rend visible les 3 elements du menu droulant
                afficher_groupe(interface,MENU_TYPE,1);
            }
            else // Sinon en position OFF
            {
                // On masque les 3 elements du menu droulant
                afficher_groupe(interface,MENU_TYPE,0);
            }

            // On doit galement actualiser le texte du bouton switch en fonction du type de terrain de la tile courante
            switch(map->tile[interface->tile].type) // En fonction du Type de terrain, le texte sera:
            {
                case SOL:
                    sprintf(interface->gui[element]->valeur,"Sol"); // Vide
                    break;
                case OBSTACLE:
                    sprintf(interface->gui[element]->valeur,"Obstacle"); // Obstacle
                    break;
                case CAMP:
                    sprintf(interface->gui[element]->valeur,"Camp"); // Position de dpart d'un joueur
                    break;
                case MORTEL:
                    sprintf(interface->gui[element]->valeur,"Mortel"); // ou Mortel
                    break;

            }
            break; // Fin du Flag SWITCH_TYPE
        case TILE_TYPE_SOL: // Si l'element est l'element "Sol" du menu deroulant
             // Si le type du terrain de la tile correspond  l'element 1 de la liste droulant
            if(map->tile[interface->tile].type==SOL && interface->gui[element]->etat==INACTIF)
            {interface->gui[element]->etat=ACTIF;} // Alors on le rend actif pour le mettre en valeur
            break;
        case TILE_TYPE_OBSTACLE:
            // Si le type du terrain de la tile correspond  l'element 2 de la liste droulant
            if(map->tile[interface->tile].type==OBSTACLE && interface->gui[element]->etat==INACTIF)
            {interface->gui[element]->etat=ACTIF;} // Alors on le rend actif pour le mettre en valeur
            break;
        case TILE_TYPE_CAMP:
            // Si le type du terrain de la tile correspond  l'element 3 de la liste droulant
            if(map->tile[interface->tile].type==CAMP && interface->gui[element]->etat==INACTIF)
            {interface->gui[element]->etat=ACTIF;} // Alors on le rend actif pour le mettre en valeur
            break;
        case TILE_TYPE_MORTEL:
            // Si le type du terrain de la tile correspond  l'element 4 de la liste droulant
            if(map->tile[interface->tile].type==MORTEL && interface->gui[element]->etat==INACTIF)
            {interface->gui[element]->etat=ACTIF;} // Alors on le rend actif pour le mettre en valeur
            break;
        case TILEACTUELLE: // Si l'element est un aperu de la tile actuelle/courante
            // Alors on fait un rognage de l'image du tileset pour n'afficher que la tile qui nous interesse
            conversion_tile_tileset(interface->tile,map->tileset.largeur,map->tileset.hauteur, &interface->gui[element]->crop);
            break;
        case TILE_COUT: // Si l'element est la saisie du cot en points de mouvement de la tile actuelle
            if (interface->gui[element]->etat==ACTIF) // Si l'element est actif - cd en cours de modification
            {
                // Alors on attribue la nouvelle valeur du cot  la tile actuelle
                sscanf(interface->gui[element]->valeur,"%ld",&map->tile[interface->tile].cout_pts); // String -> Long
            }
            else // Si au contraire l'element n'est pas encours de modification
            {
                // Alors sa valeur correspont au cout de la tile actuelle
                sprintf(interface->gui[element]->valeur,"%ld",map->tile[interface->tile].cout_pts); // Long -> String
            }
            break;
        case MINIMAP_CURSEUR:
            coord=obtenir_curseur_minimap(interface,map);

            interface->gui[element]->position.x=
                interface->gui[element-1]->position.x+coord.x+ (interface->gui[0]->crop.x*(160-2*coord.x))/(map->largeur*TILE_TAILLE);

            interface->gui[element]->position.y=
                interface->gui[element-1]->position.y+coord.y+ (interface->gui[0]->crop.y*(160-2*coord.y))/(map->hauteur*TILE_TAILLE);
            break;
        case MESSAGES:

            sscanf(interface->gui[element]->valeur,"%ld",&chat_dernier_temps);
            if( SDL_GetTicks()-chat_dernier_temps > 5000)
            {
                afficher_groupe(interface,POPUP_CHAT,0);
            }
            else
            {
                afficher_groupe(interface,POPUP_CHAT,1);
            }
            break;
        case FPS:
            sprintf(interface->gui[element]->valeur,"fps: %ld",obtenir_fps(1));
            break;
        default: // Si l'element a un flag qui ne requiert aucune actualisation spcifique
        // On ne fait rien (et on vite un avertissement du compilateur)
            break;
    }
}

 // Effectuer l'action d'un flag
void effectuer_gui(enum gui_flag flag,t_interface* interface,t_map* map)
{
    char str[255];
    /* Remarque :
    Lorsqu'un lement est "valid", par la touche entre si c'est une saisie, ou un clic pour un bouton,
    alors on doit faire l'action correpondnate, et dsigne par le flag de l'element
    */
    switch(flag)// En fonction du flag
    {
        case GENERER: // Si l'action est celle de sauvegarder
            generer_map(map,8,16,150,50,50);
            actualiser_minimap(map,interface);
            break;
        case SAUVEGARDER: // Si l'action est celle de sauvegarder
            if (sauvegarder_map(map)) // On sauvegarde la map
            {
                sprintf(str,"La map %s a correctement t sauvegarde !",map->fichier);
                afficher_message(interface, str, 0, 255, 0);
            }
            else
            {
                sprintf(str,"Erreur: La map %s ne peut pas tre sauvegarder",map->fichier);
                afficher_message(interface, str, 255, 0, 0);
            }
            break;
        case TILE_TYPE_SOL: // Si on a cliqu sur le 1er element du menu droulant pour le type de terrain
            map->tile[interface->tile].type=SOL; // On change le type  SOL
            interface->gui[ELEMENT_SWITCH_TYPE]->etat=INACTIF; // Et on desactive le switch pour masquer le menu deroulant
            break;
        case TILE_TYPE_OBSTACLE:// Si on a cliqu sur le 2eme element du menu droulant pour le type de terrain
            map->tile[interface->tile].type=OBSTACLE;// On change le type  OBSTACLE
            interface->gui[ELEMENT_SWITCH_TYPE]->etat=INACTIF; // Et on desactive le switch pour masquer le menu deroulant
            break;
        case TILE_TYPE_CAMP:// Si on a cliqu sur le 2eme element du menu droulant pour le type de terrain
            map->tile[interface->tile].type=CAMP;// On change le type  CAMP
            interface->gui[ELEMENT_SWITCH_TYPE]->etat=INACTIF; // Et on desactive le switch pour masquer le menu deroulant
            break;
        case TILE_TYPE_MORTEL:// Si on a cliqu sur le 3eme element du menu droulant pour le type de terrain
            map->tile[interface->tile].type=MORTEL;// On change le type  MORTEL
            interface->gui[ELEMENT_SWITCH_TYPE]->etat=INACTIF; // Et on desactive le switch pour masquer le menu deroulant
            break;
        case TILE_PRECEDENT: // Si on change la tile actuelle pour la prcdente
            interface->tile=(interface->tile-1)%(map->tileset.largeur*map->tileset.hauteur); // Alors on change le numero de la tile actuelle
            if (interface->tile<0) // Si apres soustraction le numero est negatif (le modulo n'tant pas strictement positif)
            {
                interface->tile+=(map->tileset.largeur*map->tileset.hauteur);// On prend le nombre congru positif.
            }
            break;
        case TILE_SUIVANT: // Si on change la tile actuelle pour la suivante
            interface->tile=(interface->tile+1)%(map->tileset.largeur*map->tileset.hauteur);// Alors on change le numero de la tile actuelle
            break;
        default:
            break;
    }
    interface->gui_actif=0; // On dsactive ensuite l'element valid (ou l'element actuellement activ)
}

// Scrolle l'ecran en fonction du curseur / Touche enfonce
void scroller_ecran(t_interface* interface,t_map* map)
{
    int scroll =0;// Teste si le pointeur est dans uen zone de scroll, sinon rinitialise le compteur du dlai
    static Uint32 scroll_temps=0; // Enregistre le dernier temps avant scroll (conserv pour un appel futur)
    Uint32 temps; // Contient le temps actuel
    temps = SDL_GetTicks(); // On rcpere le temps actuel
    long minimap_element=0,minimap_curseur=0;;
    SDL_Rect coord;
    minimap_element=obtenir_element(interface, MINIMAP);
    minimap_curseur=obtenir_element(interface, MINIMAP_CURSEUR);

    switch(interface->touche) // On vrifie la touche enfonce
    {
        case SDLK_UP: // Flche haut
            interface->gui[0]->crop.y-=32; // On scrolle vers le haut
            break;
        case SDLK_DOWN: // Flche bas
            interface->gui[0]->crop.y+=32; // On scrolle vers le bas
            break;
        case SDLK_RIGHT: // Flche droite
            interface->gui[0]->crop.x+=32; // On scroll vers la droite
            break;
        case SDLK_LEFT: // Flche gauche
            interface->gui[0]->crop.x-=32; // ON scroll vers la gache
            break;
        default: // Si la touche enfonce n'est pas une flche (ou si rien n'est enfonce)
            scroll = 0; // On initialise le test  nul

            // Si le pointeur se situe sur le bord droit de l'cran
            if (interface->pointeur.x>=(interface->gui[0]->crop.w-SCROLL_BORDURE) && interface->pointeur.x<(interface->gui[0]->crop.w))
            {
                if(temps - scroll_temps > 200) // Le temps coul doit etre d'au moisn 200ms
                {
                    interface->gui[0]->crop.x+=16; // Scrolle vers la droite
                }
                scroll = 1; // On est dans une zone de scroll
            }

            // Si le pointeur se situe sur le bord gauche de l'cran
            if (interface->pointeur.x>=0 && interface->pointeur.x<SCROLL_BORDURE)
            {
                if(temps - scroll_temps > 200) // Le temps coul doit etre d'au moisn 200ms
                {
                    interface->gui[0]->crop.x-=16; // Scrolle vers la gauche
                }
                scroll = 1; // On est dans une zone de scroll
            }

            // Si le pointeur se situe sur le bord bas de l'ecran (et pas sur la barre latrale)
            if (interface->pointeur.y>=(interface->gui[0]->crop.h-SCROLL_BORDURE) && interface->pointeur.y<(interface->gui[0]->crop.h)&& interface->pointeur.x<interface->gui[0]->crop.w)
            {
                if(temps - scroll_temps > 200) // Le temps coul doit etre d'au moisn 200ms
                {
                    interface->gui[0]->crop.y+=16; // Scrolle vers le bas
                }
                scroll = 1; // On est dans une zone de scroll
            }

            // Si le pointeur se situe sur le bord haut de l'ecran (et pas sur la barre latrale)
            if (interface->pointeur.y>=0 && interface->pointeur.y<SCROLL_BORDURE && interface->pointeur.x<interface->gui[0]->crop.w)
            {
                if(temps - scroll_temps > 200) // Le temps coul doit etre d'au moisn 200ms
                {
                    interface->gui[0]->crop.y-=16; // Scrolle vers le haut
                }
                scroll = 1; // On est dans une zone de scroll
            }

            if (!scroll) // Si on n'est pas dans une zone de scroll
            {
                scroll_temps=temps; // On met le dernier temps avant scroll au temps actuel
            }

            if (interface->clic && minimap_element != -1 && minimap_curseur != -1 )
            {
                if (    interface->pointeur.x>=interface->gui[minimap_element]->position.x
                    &&  interface->pointeur.x<interface->gui[minimap_element]->position.x+160
                    &&  interface->pointeur.y>=interface->gui[minimap_element]->position.y
                    &&  interface->pointeur.y<interface->gui[minimap_element]->position.y+160
                   )
                {
                    coord=obtenir_curseur_minimap(interface,map);

                    interface->gui[0]->crop.x=((interface->pointeur.x-coord.x-(interface->gui[minimap_element]->position.x-1))*map->largeur*TILE_TAILLE)/(160-2*coord.x);
                    interface->gui[0]->crop.y=((interface->pointeur.y-coord.y-(interface->gui[minimap_element]->position.y-1))*map->hauteur*TILE_TAILLE)/(160-2*coord.y);
                }
            }
            break;
    }

    // Si apres scroll l'cran sort de la map  droite
    if (interface->gui[0]->crop.x>(map->largeur*TILE_TAILLE - (interface->gui[0]->crop.w+8)))
    {interface->gui[0]->crop.x=(map->largeur*TILE_TAILLE - (interface->gui[0]->crop.w+8));} // On limite l'ecran au bord droit
    // Si apres scroll l'cran sort de la map en bas
    if (interface->gui[0]->crop.y>(map->hauteur*TILE_TAILLE - interface->gui[0]->crop.h))
    {interface->gui[0]->crop.y=(map->hauteur*TILE_TAILLE - interface->gui[0]->crop.h);} // On limite l'ecran au bord bas
    // Si apres scroll l'cran sort de la map  gauche
    if (interface->gui[0]->crop.x<0){interface->gui[0]->crop.x=0;} // On limite l'ecran au bord gauche
    // Si apres scroll l'cran sort de la map en haut
    if (interface->gui[0]->crop.y<0){interface->gui[0]->crop.y=0;} // On limite l'ecran au bord haut
}

long obtenir_element(t_interface *interface,enum gui_flag flag)
{
    long n,element=-1;

    for (n=0; n<interface->gui_taille;n++)
    {
        if (interface->gui[n]->flag==flag)
        {
            element=n;;
        }
    }
    return element;
}

// Affiche / Masque un groupe d'elements en fonction de visible
void afficher_groupe(t_interface *interface, enum gui_groupe groupe, long visible)
{
    long n;

    for (n=0; n<interface->gui_taille;n++)
    {
        if (interface->gui[n]->groupe==groupe)
        {
            interface->gui[n]->visible=visible;
        }
    }
}

void afficher_message(t_interface *interface, char *txt, long rouge, long vert, long bleu)
{
    long chat_element;
    SDL_Surface* mess;

    chat_element=obtenir_element(interface,MESSAGES);


    if (chat_element!=-1)
    {

        mess=interface->gui[chat_element]->image;

        SDL_Surface *texte; //Contient le texte sous forme d'image  copier sur la destination (resul)
        SDL_Rect position; //Contient les paramtres de position pour les diffrents affichages  effectuer
        SDL_Color couleur; //Contient la couleur du texte  afficher

        //Convertit le texte en une image  coller sur ecran
        couleur.r = rouge;
        couleur.g = vert;
        couleur.b = bleu;
        texte = TTF_RenderText_Blended(interface->font, txt, couleur); //crit le texte
        //Scroll
        interface->gui[chat_element]->image = SDL_CreateRGBSurface(mess->flags, mess->w, mess->h, mess->format->BitsPerPixel, mess->format->Rmask, mess->format->Gmask, mess->format->Bmask, mess->format->Amask);
        SDL_FillRect(interface->gui[chat_element]->image, NULL, SDL_MapRGBA(mess->format, 0, 0, 0, 0));
        SDL_SetAlpha(mess, 0,255); // On desactive le SRCALPHA pour copier les donnes RGBA, et remplacer l'alpha de la destination
        SDL_SetAlpha(texte, 0,255); // On desactive le SRCALPHA pour copier les donnes RGBA, et remplacer l'alpha de la destination

        position.x = 0;
        position.y = texte->h;
        position.w = mess->w;
        position.h = mess->h - texte->h;
        SDL_BlitSurface(mess, &position, interface->gui[chat_element]->image, NULL);
        //Affichage du nouveau texte
        position.x = 0;
        position.y = mess->h - texte->h;
        SDL_BlitSurface(texte, NULL, interface->gui[chat_element]->image, &position);
        //On efface l'image du texte
        SDL_FreeSurface(texte);
        SDL_FreeSurface(mess);

        sprintf(interface->gui[chat_element]->valeur,"%ld",(long)SDL_GetTicks());
    }
    else
    {
        printf("Erreur lors de l'obtention d'un element du GUI\n");
    }
}

long obtenir_fps(long incrementer)
{
    static long dernier_f=0,frames=0,dernier_temps=0;

    if (dernier_temps-SDL_GetTicks()>= 1000)
    {
        dernier_f=frames;
        frames=0;
        dernier_temps+=1000;
    }

    frames+=incrementer;

    return dernier_f;
}

// Renvoie le pixel d'une surface
Uint32 GetPixel(SDL_Surface* surface, long x, long y)
{
    long bpp = surface->format->BytesPerPixel; // Octets par pixel
    /*  p est l'addresse du pixel que l'on veut rcuprer */
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp)
    {
    case 1:
        return *p;

    case 2:
        return *(Uint16 *)p;

    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
            return p[0] << 16 | p[1] << 8 | p[2];
        else
            return p[0] | p[1] << 8 | p[2] << 16;

    case 4:
        return *(Uint32 *)p;

    default:
        return 0;  /* Ne devrait pas arriver, mais supprime les avertissements du compilateur */
    }
}

SDL_Rect obtenir_curseur_minimap(t_interface* interface,t_map *map)
{
    double ratio;

    SDL_Rect curseur;
    if(map->largeur < map->hauteur)
    {
        ratio = 160.0 / map->hauteur;
        curseur.x = (160.0 - map->largeur * ratio) / 2;
        curseur.y = 0;
    }
    else
    {
        ratio = 160.0 / map->largeur;
        curseur.x = 0;
        curseur.y = (160.0 - map->hauteur * ratio) / 2;
    }

    curseur.w = ((interface->gui[0]->crop.w+8) * ratio + TILE_TAILLE - 1) / TILE_TAILLE;
    curseur.h = (interface->gui[0]->crop.h * ratio + TILE_TAILLE - 1) / TILE_TAILLE;

    if (curseur.w > 160){curseur.w=160;}
    if (curseur.h > 160){curseur.h=160;}

    return curseur;
}
